 /* - IRCodeListener -
 * Display code data after a code event
 *
 * Copyright 2011 Phidgets Inc.
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License.
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */
package listeners;

import com.phidgets.IRPhidget;
import com.phidgets.event.CodeEvent;
import com.phidgets.event.CodeListener;

import javax.swing.JTextField;
import javax.swing.JFrame;

public class IRCodeListener implements CodeListener {

    private JFrame appFrame;
    private JTextField codeTxt;
    private JTextField bitLengthTxt;
    private JTextField repeatCountTxt;
    private static int repeatCount;

    public IRCodeListener(JFrame appFrame, JTextField codeTxt, JTextField bitLengthTxt, JTextField repeatCountTxt) {

        this.appFrame = appFrame;
        this.codeTxt = codeTxt;
        this.bitLengthTxt = bitLengthTxt;
        this.repeatCountTxt = repeatCountTxt;
        repeatCount = 0;
    }

    public void code(CodeEvent ce) {
        IRPhidget ir = (IRPhidget) ce.getSource();
        codeTxt.setText("0x" + ce.getCode().toString());
        bitLengthTxt.setText(Integer.toString(ce.getCode().getBitCount()));

        repeatCount++;
        if (!ce.getRepeat()) {
            repeatCount = 0;

        }
        repeatCountTxt.setText(Integer.toString(repeatCount));

    }
}
